


=================
**Quiz - 1**


What is the goal of Network Security Baseline ? 

a. To help outline key security elements that should be addressed in the first phase of implementing defense-in-depth.  
b. To provide a comprehensive framework for configuring devices to meet minimum security standards.  
c. To establish a set of best practices that reduce the risk of common cyber threats to network infrastructure.  
d. To simplify ongoing security management by offering standardized security recommendations for Cisco devices.







Correct Answer - **a** 












=================
**Quiz - 2**



  
Which control plane security feature on Cisco IOS XE devices is specifically designed to rate-limit or filter packets destined for control plane processes, thereby protecting the device CPU and memory from excessive or malicious traffic?

A. Infrastructure Access Control Lists (iACLs)  
B. Control Plane Policing (CoPP)  
C. Spanning Tree Protocol (STP) Protection  
D. Routing Protocol Authentication








---

**Correct Answer:**  
**B. Control Plane Policing (CoPP)**

**Reason:**  
Control Plane Policing (CoPP) is specifically designed to rate-limit or filter packets directed to the control plane processes of a device, helping to protect critical resources like CPU and memory from being overwhelmed by excessive or malicious traffic. This ensures the reliability and availability of the device, which is crucial for maintaining network stability.












=================
**Quiz - 3**





A network engineer notices that the CPU utilization on a Cisco router has suddenly spiked, causing routing protocol neighbor relationships to intermittently drop and management sessions to become unresponsive. After investigating, they find a large amount of traffic is being sent directly to the device’s control plane.

Which action should the engineer prioritize to most effectively mitigate this issue while maintaining essential management and routing functions?

A. Increase the router's physical memory  
B. Apply Control Plane Policing (CoPP) to rate-limit specific traffic types  
C. Disable all routing protocols temporarily  
D. Configure additional VLANs to segment user traffic





---

**Correct Answer:**  
**B. Apply Control Plane Policing (CoPP) to rate-limit specific traffic types**

**Reason:**  
CoPP allows selective rate-limiting of traffic destined for the control plane, helping prevent excessive or malicious traffic from overwhelming device resources. This approach protects the device’s CPU and memory while ensuring that necessary management and routing functions remain operational.














=================
**Quiz - 4**




Which of the following best describes the primary functions of the control plane, data plane, and management plane in a network device?


A.

- **Control plane:** Forwards user traffic
- **Data plane:** Handles routing protocol updates
- **Management plane:** Manages device configurations

B.

- **Control plane:** Handles routing protocol updates and network topology information
- **Data plane:** Forwards user traffic based on routing decisions
- **Management plane:** Allows administrators to configure and monitor the device

C.

- **Control plane:** Provides CLI/GUI access for device management
- **Data plane:** Generates routing protocol advertisements
- **Management plane:** Filters and rate-limits packets to the control plane

D.

- **Control plane:** Encrypts user data
- **Data plane:** Stores device logs
- **Management plane:** Updates routing tables










---

**Correct Answer:**  
**B.**

- **Control plane:** Handles routing protocol updates and network topology information
- **Data plane:** Forwards user traffic based on routing decisions
- **Management plane:** Allows administrators to configure and monitor the device

**Reason:**  
The control plane is responsible for making decisions about where traffic is sent (routing, topology updates), the data plane is responsible for forwarding actual user traffic, and the management plane is used for administrative access and monitoring.











=================
**Quiz - 5**




A network administrator wants to enhance the security of device management on several Cisco IOS XE routers. The goal is to ensure that management traffic only enters the routers through specifically designated interfaces, and to minimize exposure to potential management packet floods on other interfaces.  
Which feature should the administrator implement to achieve this objective?

A. Enable Control Plane Policing (CoPP) on all interfaces  
B. Configure Management Plane Protection (MPP) for management protocols  
C. Apply Infrastructure ACLs (iACLs) to filter all inbound traffic  
D. Implement TACACS+ for administrator authentication









---

**Correct Answer:**  
**B. Configure Management Plane Protection (MPP) for management protocols**

**Reason:**  
Management Plane Protection (MPP) allows administrators to specify which interfaces are permitted to accept management traffic, ensuring only designated interfaces can be used for device management. This reduces the attack surface and prevents management packet floods from reaching the CPU via non-management interfaces.













=================
**Quiz - 6**




Which of the following correctly matches each feature to its primary function in securing device management access?

A.

- MPP: Restricts management traffic to designated interfaces
- Access Class: Filters management access by protocol
- Service ACLs: Allow management access only from specific IPs & interfaces

B.
- MPP: Limits source IPs for VTY access
- Access Class: Designates management interfaces
- Service ACLs: Restricts protocols on routers and switches

C.
- MPP: Filters user data traffic on all interfaces
- Access Class: Controls routing protocol authentication
- Service ACLs: Enables SNMP traps

D.
- MPP: Provides authentication for device administrators
- Access Class: Manages OOB access
- Service ACLs: Implements VPN tunnels

---

**Correct Answer:**  
**A.**

- **MPP** is used to restrict management traffic to designated interfaces.
- **Access Class (Cisco IOS XE):** Filters management access by protocol (Telnet, SSH, HTTP, HTTPS).
- **Service ACLs (Firewalls):** Allow management access (such as SSH, Telnet, HTTP etc.) only from specific IP sources and only on specific interfaces 










=================
**Quiz - 7**


Which two options are OOB management connections? (Choose two.)

- router management VRF connection
    
- Cisco Secure Email Gateway data interface, also used for management
    
- firewall console connection
    
- Cisco Secure Web Appliance in-band connection
    
- switch SSH connection to IP phone dedicated VLAN SVI




### Answer

The correct answers are **firewall console connection** and **router management VRF connection**. Console connection is a connection type not using the data network and, for this reason, can be considered OOB management. The management VRF feature creates a dedicated routing table for management, which can be used as a dedicated management network with isolation from the data network.






=================
**Quiz - 8**


Which statement is correct about NetFlow and IPFIX?

- NetFlow and IPFIX are used to measure the bandwidth usage on a router interface.
    
- NetFlow can be implemented on a Cisco router and IPFIX on a Cisco Secure Firewall ASA.
    
- NetFlow protocol records can be exported to an external SIEM server for analysis and correlation.
    
- NetFlow is a standard IETF protocol, IPFIX is a Cisco proprietary protocol.






### Answer

The correct answer is **NetFlow protocol records can be exported to an external SIEM server for analysis and correlation**. 



NetFlow is a Cisco feature that can be enabled on many types of devices, including Cisco routers and switches, Cisco Secure Firewall Threat Defense, and Cisco Secure Firewall ASA. NetFlow caches and generates records about network traffic and its characteristics. After the information is collected, it can be exported from the network device to an external SIEM server. IPFIX, the equivalent of NetFlow, is, on the other hand, an open standard, which is defined by the IETF and is not supported on Cisco Secure Firewall ASA devices.







=================
**Quiz - 9**






A network operations team wants to proactively detect and investigate security threats across their infrastructure devices. The team has established a network traffic baseline and enabled NetFlow/IPFIX exports, syslog, and SNMP traps on all routers and switches. They plan to centralize analysis for better threat detection. Which solution best complements their setup to accelerate threat response and provide advanced behavioral analytics?


A) Deploy a SIEM server to normalize and correlate telemetry data  
B) Increase ACL logging on all devices to capture more events  
C) Disable time synchronization to avoid timestamp mismatches  
D) Only review syslog entries for failed login attempts








---

**Correct Answer:**  
**A) Deploy a Security Information and Event Management (SIEM) server to normalize and correlate telemetry data**

---

**Reason:**  
A SIEM server is designed to aggregate telemetry from multiple sources, normalize data for easy comparison, and correlate events for comprehensive threat detection and faster response. This approach is in line with Cisco's recommended best practices for centralized security monitoring and incident analysis.








=================
**Quiz - 10**





A network engineer is tasked with securing the Layer 2 data plane of a campus network. The goal is to prevent both DHCP server spoofing and ARP spoofing attacks, while also ensuring that end hosts are properly isolated within the same VLAN without the need for multiple subnets. Which combination of features should the engineer deploy to meet all these requirements?

A) Enable DHCP snooping, Dynamic ARP Inspection, and Private VLANs  
B) Configure QoS policing, MACsec encryption, and broadcast storm control  
C) Use MAC address filtering, port security, and access control lists  
D) Implement VLAN trunking, spanning tree protocol, and port mirroring






---

**Correct Answer:**  
**A) Enable DHCP snooping, Dynamic ARP Inspection, and Private VLANs**

---

**Reason:**  
DHCP snooping prevents DHCP server spoofing attacks, Dynamic ARP Inspection (ARP inspection) stops ARP spoofing attacks, and Private VLANs provide isolation between hosts within the same VLAN without needing separate subnets—all directly addressing the scenario’s requirements.














=================
**Quiz - 11**



During a security audit, a network administrator observes excessive broadcast, multicast, and unicast traffic overwhelming a switch port. At the same time, the administrator wants to ensure encrypted transmission between switches over a dark-fiber link. Which two Layer 2 features should be implemented to address both issues?

A) Storm control and MACsec encryption  
B) ARP inspection and DHCP snooping  
C) Port security and Private VLANs  
D) QoS policing and VLAN trunking






**Correct Answer:**  
**A) Storm control and MACsec encryption**

---

**Reason:**  
Storm control mitigates excessive broadcast, multicast, and unicast traffic on switch ports, while MACsec encryption provides Layer 2 encryption for secure transmission between switches over wired links. This combination directly addresses the audit findings.



### What is Dark Fiber?
- **Optical fiber** is a type of cable that transmits data as light pulses.
- **Dark fiber** means the fiber is installed but not currently being used (no light—hence, "dark").
- When organizations lease or purchase dark fiber, they "light" it with their own networking equipment to transmit data.
### Typical Uses
- Connecting data centers, campuses, or buildings directly.
- Providing high-bandwidth, secure, and private connections.
### Why Use Dark Fiber?
- Offers complete control over network speed, security, and equipment.
- Useful for organizations needing dedicated, private, or high-capacity links.






=================
**Quiz - 12**







A network administrator needs to protect the organization’s Layer 3 infrastructure from IP spoofing attacks and prevent hosts on access ports from assuming unauthorized IP addresses. Which combination of features best meets both requirements?

A) Unicast Reverse Path Forwarding (uRPF) and Port Security  
B) Access Control Lists (ACLs) and IP Source Guard  
C) Unicast Reverse Path Forwarding (uRPF) and IP Source Guard  
D) Dynamic ARP Inspection and Access Control Policy





---

**Correct Answer:**  
**C) Unicast Reverse Path Forwarding (uRPF) and IP Source Guard**

---

**Reason:**  
uRPF specifically checks incoming packets for valid source addresses to prevent IP spoofing at Layer 3, while IP Source Guard ensures that only valid, assigned IP addresses are used on access ports, preventing hosts from impersonating others. The other options either do not directly address both aspects of the scenario or lack the required specificity.



**Difference** below if you are confused the difference between the two - 

|Feature|Where It’s Applied|What It Protects Against|How It Works|Example Scenario|
|---|---|---|---|---|
|**uRPF**|**Layer 3 interface (Router)**|IP address spoofing from outside the network|Checks if the source IP of a received packet is reachable via the interface it arrived on, according to the routing table|**Example:**<br>If a packet arrives on a router’s WAN interface with a source IP address that should only exist on the LAN, uRPF will drop it—because it’s not a valid path. This blocks spoofed traffic from the Internet pretending to be from your internal network.|
|**IP Source Guard**|**Layer 2 access port (Switch)**|Hosts on the same subnet spoofing each other’s IP addresses|Blocks traffic from a port unless the source IP matches a legitimate DHCP binding or static binding for that port|**Example:**<br>Two users on the same switch, Alice and Bob. If Bob tries to manually set his IP to Alice’s (to impersonate her), the switch blocks Bob’s traffic because his port does not have a binding for Alice’s IP.|









=================
**Quiz - 13**





















=================
**Quiz - 14**






















=================
**Quiz - 15**


















=================
**Quiz - 16**






















=================
**Quiz - 17**






















=================
**Quiz - 18**









